//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "editor.h"
#include "run.h"
#include "program.h"
#include "appstrings.h"
#include "about.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfMain *fMain;
//---------------------------------------------------------------------------
__fastcall TfMain::TfMain(TComponent* Owner): TForm(Owner){}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::FormCreate(TObject *Sender)
{
  oStatusBar->Panels->Items[0]->Alignment = taCenter;
  Application->OnHint = DisplayHint;
  mNew->Click();
}
//---------------------------------------------------------------------------
void __fastcall TfMain::FormCloseQuery(TObject *Sender, bool &CanClose)
{
  if(!AskToSaveChanges()) CanClose = false;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::oTextChange(TObject *Sender)
{
  if(oText->Modified)
    oStatusBar->Panels->Items[0]->Text = sModified;
  else
    oStatusBar->Panels->Items[0]->Text = "";
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::mNewClick(TObject *Sender)
{
  if(AskToSaveChanges()) {
    oFile.Name = sUntitled;
    oFile.Path = "";
    oText->Lines->Clear();
    SetFileName();
  }
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mSaveClick(TObject *Sender)
{
  SaveFile(false);
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mSaveAsClick(TObject *Sender)
{
  SaveFile(true);
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mOpenClick(TObject *Sender)
{
  if(AskToSaveChanges()) {
    oOpenDialog->Filter = sFileFilter;
    oOpenDialog->Options << ofPathMustExist << ofFileMustExist;
    if(oOpenDialog->Execute()){
      oText->Lines->LoadFromFile(oOpenDialog->FileName);
      AnsiString FileName = ExpandFileName(oOpenDialog->FileName);
      oFile.Name = ExtractFileName(FileName);
      oFile.Path = ExtractFileDir(FileName);
      SetFileName();
    }
  }
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mExitClick(TObject *Sender)
{
  Close();
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::mUndoClick(TObject *Sender)
{
  oText->Undo();
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mCutClick(TObject *Sender)
{
  oText->CutToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mCopyClick(TObject *Sender)
{
  oText->CopyToClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mPasteClick(TObject *Sender)
{
  oText->PasteFromClipboard();
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mSelectAllClick(TObject *Sender)
{
  SendMessage(oText->Handle, EM_SETSEL, 0, -1);
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mDeselectClick(TObject *Sender)
{
  SendMessage(oText->Handle, EM_SETSEL, 0, 0);
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mGotoLineClick(TObject *Sender)
{
//
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mFindClick(TObject *Sender)
{
//
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mFindNextClick(TObject *Sender)
{
//
}
//---------------------------------------------------------------------------
void __fastcall TfMain::mReplaceClick(TObject *Sender)
{
//
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::mRunClick(TObject *Sender)
{
   fRun->RunAs = RStateRunning;
   fRun->AutoStopAtLine = 0;

   if(RResultError == fRun->ShowModal()) {
     oText->SelStart = fRun->GotoPos - 1;
     oText->SelLength = 1;
   }
}

//---------------------------------------------------------------------------
void __fastcall TfMain::mRunToCursorClick(TObject *Sender)
{
   fRun->RunAs = RStateRunning;
	 fRun->AutoStopAtLine = SendMessage(oText->Handle, EM_LINEFROMCHAR, oText->SelStart, 0) + 1;

   if(RResultError == fRun->ShowModal()) {
     oText->SelStart = fRun->GotoPos - 1;
     oText->SelLength = 1;
   }
}

//---------------------------------------------------------------------------
void __fastcall TfMain::mTraceClick(TObject *Sender)
{
   fRun->RunAs = RStateBreak;
   fRun->AutoStopAtLine = 0;

   if(RResultError == fRun->ShowModal()) {
     oText->SelStart = fRun->GotoPos - 1;
     oText->SelLength = 1;
   }
}

//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::mAboutClick(TObject *Sender)
{
  fAbout->ShowModal ();
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfMain::DisplayHint(TObject *Sender)
{
  oStatusBar->Panels->Items[1]->Text =  Application->Hint;
}
//---------------------------------------------------------------------------
void __fastcall TfMain::SaveFile(bool vSaveAs)
{
  bool vToSave = true;

  oSaveDialog->FileName = oFile.Name;
  oSaveDialog->DefaultExt = sFileExtension;
  if(vSaveAs || oFile.Path.IsEmpty()){
    oSaveDialog->Filter = sFileFilter;
    oSaveDialog->Options << ofOverwritePrompt << ofPathMustExist << ofNoReadOnlyReturn;
    if(!oSaveDialog->Execute()) vToSave = false;
  }
  if(vToSave) {
   oText->Lines->SaveToFile(oSaveDialog->FileName);
   AnsiString FileName = ExpandFileName(oSaveDialog->FileName);
   oFile.Name = ExtractFileName(FileName);
   oFile.Path = ExtractFileDir(FileName);
   SetFileName();
   oText->Modified = false; oTextChange(0);
  }
}
//---------------------------------------------------------------------------
void __fastcall TfMain::SetFileName(void)
{
  Caption = oFile.Name + " - " + sAppName;
  Application->Title = Caption;
}
//---------------------------------------------------------------------------
bool __fastcall TfMain::AskToSaveChanges(void)
{
  AnsiString vStr = sSaveChanges;
  int vRes;

  vStr.Insert(oFile.Name, vStr.Length());
  if(oText->Modified) vRes = Application->MessageBox(vStr.c_str(), sAppName, MB_YESNOCANCEL + MB_ICONQUESTION);

  if(vRes == ID_CANCEL) return false;
  if(vRes == ID_YES) mSaveClick(NULL);
  return true;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------



void __fastcall TfMain::FormActivate(TObject *Sender)
{
  UINT ui = SCSizeOfTabCharacter*32;

  SendMessage (oText->Handle, EM_SETTABSTOPS, (WPARAM) 1, (LPARAM) &ui);
  InvalidateRect (oText->Handle, NULL, TRUE);
}
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------

