//---------------------------------------------------------------------------
#ifndef programH
#define programH
//---------------------------------------------------------------------------
#include "inputlist.h"
#include <comctrls.hpp>
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------

// values of instruction types
#define IType_NONE       0
#define IType_STACK     10
#define IType_SET       20
#define IType_ADD       21
#define IType_SUB       22
#define IType_MUL       23
#define IType_DIV       24
#define IType_PUSH      30
#define IType_POP       31
#define IType_GOTO      40
#define IType_INPUT     50
#define IType_OUTPUT    51
#define IType_IF        60
#define IType_EXIT     100

// values of condition types
#define CType_NONE      0
#define CType_ZERO      11
#define CType_NEG       12
#define CType_EMPTY     21
#define CType_NOT       31

// values of RunningState
#define RStateRunning      (1 << 0)
#define RStateNext         (1 << 1)
#define RStateBreak        (1 << 10)
#define RStateStop         (1 << 15)
#define RStateFinished     (1 << 16)
#define RStateError        (1 << 20)

//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
typedef struct AStackItem {
  int Value;
  AStackItem * Next;
} TStackItem, * PStackItem;

typedef struct AStack {
  char * Name;
  PStackItem StackItems;
  AStack * Next;
} TStack, * PStack;

typedef struct ACondition {
  int Type;
  PStack Stack;
  ACondition * SubCondition;
  ACondition * Next; 
} TCondition, * PCondition;

typedef struct AInstruction {
  int SourceChar, SourceLine;
  int Type;
  PStack Stack;
  int Value;
  PCondition Condition;
  char * GotoLabelName, * ElseLabelName;
  AInstruction * Goto, * Else;
  AInstruction * Next;
} TInstruction, * PInstruction;

typedef struct AInstrLabel {
  char * Name;
  PInstruction Destination;
  AInstrLabel * Next;
} TInstrLabel, * PInstrLabel;
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
class TProgram {
public:
        __fastcall TProgram(void);
        __fastcall ~TProgram(void);
public:
        void         __fastcall ClearInstrLabels(void);
        void         __fastcall AddInstrLabel(char * vStr, PInstruction vInstruction);
        PInstruction __fastcall FindInstrLabel(char * vStr);

        void         __fastcall ClearStacks(void);
        bool         __fastcall AddStack(char * vStr);
        PStack       __fastcall FindStack(char * vStr);
        bool         __fastcall PushStackValue(PStack vStack, int * vValue);
        bool         __fastcall PopStackValue(PStack vStack, int * vValue);
        bool         __fastcall PopStackValue(PStack vStack);

        int          __fastcall StacksCount (void);
        PStack       __fastcall GetStackByNumber(int i);

        void         __fastcall ClearInstructions(void);
        PInstruction __fastcall NewInstruction(void);
        void         __fastcall AddInstruction(PInstruction vInstruction);

        void         __fastcall ClearConditions(void);
        PCondition   __fastcall NewCondition(void);
public:
        int          __fastcall LinkProgram(TStatusPanel * vStatusText);
        int          __fastcall RunProgram(TStatusPanel * vStatusText, TInputList * vInputList, void _fastcall WriteOutput (int), int vRunningState);
        int          __fastcall ContinueProgram(TStatusPanel * vStatusText, TInputList * vInputList, void _fastcall WriteOutput (int));
        int          __fastcall SolveCondition (PCondition vCondition);
public:
        int RunningState;
        int vWorkingRegister;
private:
        PInstruction vInstructions, vInstructionsPos, vFirstInstruction;
        PInstrLabel vInstrLabels, vInstrLabelsPos;
        PStack vStacks, vStacksPos;
        PCondition vConditionList;

};
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
#endif
