//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "break.h"
#include "editor.h"
#include "run.h"
#include "input.h"
#include "program.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfBreak *fBreak;

//---------------------------------------------------------------------------
__fastcall TfBreak::TfBreak(TComponent* Owner) : TForm(Owner)
{
}

//---------------------------------------------------------------------------
void __fastcall TfBreak::FormActivate(TObject *Sender)
{
  oCheckListBox->ItemIndex = fRun->GotoLine - 1;

  int    i = 0;

  oStatusBar->Panels->Items[0]->Text = "WR: ";
  oStatusBar->Panels->Items[0]->Text += fRun->GetWorkingRegisterValue ();

  oStatusBar->Panels->Items[1]->Text = "In: ";
  if (fInput->oInputList->GetNextValue (&i)) {
    oStatusBar->Panels->Items[1]->Text += i;
  } else {
    oStatusBar->Panels->Items[1]->Text += "EMPTY";
  }

  oStatusBar->Panels->Items[2]->Text = "";
  int count = fRun->oProgram->StacksCount ();
  for (int j = 0; j < count; j++) {
    PStack stack = fRun->oProgram->GetStackByNumber (j);
    if (stack) {
      if (*(stack->Name)) {
        oStatusBar->Panels->Items[2]->Text += stack->Name;
        oStatusBar->Panels->Items[2]->Text += ": ";
      } else {
        oStatusBar->Panels->Items[2]->Text += "Primary Stack: ";
      }
    }
    if (stack->StackItems) {
      PStackItem items = stack->StackItems;
      int k;
      for (k = 0; k < 4 && items; k++) {
        oStatusBar->Panels->Items[2]->Text += items->Value;
        if (0 != (items = items->Next)) {
          oStatusBar->Panels->Items[2]->Text += ",";
        }
      }
      if (items) {
        oStatusBar->Panels->Items[2]->Text += "...";
      }
    } else {
      oStatusBar->Panels->Items[2]->Text += "EMPTY";
    }
    oStatusBar->Panels->Items[2]->Text += "; ";
  }

}

//---------------------------------------------------------------------------
AnsiString __fastcall TfBreak::RepaireTabs (AnsiString str)
{
  int pos;
  AnsiString spaces;

  while (0 != (pos = str.AnsiPos ("\t")))
  {
        str.Delete (pos, 1);
        str.Insert (spaces.StringOfChar(' ', SCSizeOfTabCharacter*8 - ((pos-1) % (SCSizeOfTabCharacter*8)) ), pos);
  }

  return str;
}

//---------------------------------------------------------------------------
void __fastcall TfBreak::ResetBreak ()
{
  // caption...
  Caption = fMain->Caption + " - [break]";

  // copy source code...
  int count = fMain->oText->Lines->Count;

  oCheckListBox->Items->Clear ();

  for (int i = 0; i < count; i++) {
    oCheckListBox->Items->Add (RepaireTabs (fMain->oText->Lines->Strings[i]));
  }

  // setup breaks...
  count = fMain->oText->Lines->Count;

  for (int i = 0; i < count; i++) {
    if (oCheckListBox->Items->Strings[i].UpperCase().AnsiPos ("<BREAK>")) {
      SetBreakpoint (i, true);
    }
  }
}

//---------------------------------------------------------------------------
bool __fastcall TfBreak::GetBreakpoint (int line)
{
  if (fRun->AutoStopAtLine && (line == fRun->AutoStopAtLine - 1)) {
    return true;
  }

  if (0 < line && line < fMain->oText->Lines->Count) {
    return oCheckListBox->Checked[line];
  }

  return false;
}

//---------------------------------------------------------------------------
void __fastcall TfBreak::SetBreakpoint (int line, bool value)
{
  if (line < fMain->oText->Lines->Count) {
    oCheckListBox->Checked[line] = value;
  }
}
//---------------------------------------------------------------------------
void __fastcall TfBreak::mStopClick(TObject *Sender)
{
  ModalResult = BResultStop;
}

//---------------------------------------------------------------------------
void __fastcall TfBreak::mContinueClick(TObject *Sender)
{
  ModalResult = BResultContinue;
}

//---------------------------------------------------------------------------
void __fastcall TfBreak::mNextClick(TObject *Sender)
{
  ModalResult = BResultNext;
}

//---------------------------------------------------------------------------
void __fastcall TfBreak::oStatusBarDblClick(TObject *Sender)
{
  AnsiString str = oStatusBar->Panels->Items[2]->Text;
  int i;

  while (0 != (i = str.AnsiPos (";")))
  {
    str.Delete (i, 1);
    str.Insert ("\n", i);
  }

  Application->MessageBox (str.c_str (), Caption.c_str (), MB_OK	| MB_ICONINFORMATION);
}

//---------------------------------------------------------------------------

