//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <ctype.h>
#include "input.h"
#include "appstrings.h"
#include "editor.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"

TfInput *fInput;
//---------------------------------------------------------------------------
__fastcall TfInput::TfInput(TComponent* Owner): TForm(Owner){}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfInput::FormResize(TObject *Sender)
{
  oOldInputs->Width = ClientWidth;
  oText->Width = ClientWidth;
  oText->Height = ClientHeight - oText->Top - oOkButton->Height - 12;
  oOkButton->Left = ClientWidth - oCancelButton->Width - oOkButton->Width - 14;
  oCancelButton->Left = ClientWidth - oCancelButton->Width - 8;
  oOkButton->Top = ClientHeight - oOkButton->Height - 6;
  oCancelButton->Top = ClientHeight - oCancelButton->Height - 6;
}
//---------------------------------------------------------------------------
void __fastcall TfInput::FormCanResize(TObject *Sender, int &NewWidth, int &NewHeight, bool &Resize)
{
  if(NewWidth < oOkButton->Width + oCancelButton->Width + 50) Resize = false;
  if(NewHeight < oOkButton->Height + oOldInputs->Height + 80) Resize = false;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfInput::oOkButtonClick(TObject *Sender)
{
  int check = oInputList->ParseText(oText->Text);
  if(check == 0) {
    if(oOldInputs->Items->IndexOf(oText->Text) == -1)
    oOldInputs->Items->Append(oText->Text);
  } else {
    ModalResult = mrNone;
    ShowErrorMsg(sUnrecognizedCharacter);
    oText->SelStart = check - 1;
    oText->SelLength = 1;
    SetFocusedControl (oText);
  }
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfInput::FormCreate(TObject *Sender)
{
  oInputList = new TInputList;
}

//---------------------------------------------------------------------------
void __fastcall TfInput::FormShow(TObject *Sender)
{
  Caption = fMain->Caption + " - [input]";
  SetFocusedControl (oText);
}

//---------------------------------------------------------------------------
void __fastcall TfInput::FormDestroy(TObject *Sender)
{
  delete oInputList;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------

