//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "inputlist.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
__fastcall TInputList::TInputList(void)
{
  vNumbers = NULL;
  vNumbersPos = NULL;
}
//---------------------------------------------------------------------------
__fastcall TInputList::~TInputList(void)
{
  Clear();
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TInputList::Clear(void)
{
  while(vNumbers){
    vNumbersPos = vNumbers;
    vNumbers = vNumbers->Next;
    delete vNumbersPos;
  }
}
//---------------------------------------------------------------------------
void __fastcall TInputList::Add(int value)
{
  PNumber vNewNumbers = new TNumber;
  vNewNumbers->Value = value;
  vNewNumbers->Next = 0;

  if (vNumbers == 0)
   {
    vNumbers = vNewNumbers;
   }
  else
   {
    vNumbersPos = vNumbers;
    while (vNumbersPos->Next) {
      vNumbersPos = vNumbersPos->Next;
    }
    vNumbersPos->Next = vNewNumbers;
   }
}
//---------------------------------------------------------------------------
void __fastcall TInputList::Reset(void)
{
  vNumbersPos = vNumbers;
}
//---------------------------------------------------------------------------
bool __fastcall TInputList::Next(int * value)
{
  if(vNumbersPos) {
    *value = vNumbersPos->Value;
    vNumbersPos = vNumbersPos->Next;
    return true;
  }
  return false;
}

//---------------------------------------------------------------------------
bool __fastcall TInputList::GetNextValue(int * value)
{
  if(vNumbersPos) {
    *value = vNumbersPos->Value;
    return true;
  }
  return false;
}

//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
int __fastcall TInputList::ParseText(AnsiString vText)
{
   char * ipos = vText.c_str();
   char * dpos = ipos;
   int number = -1;
   bool negative = false;

   Clear();

   do {
     Application->ProcessMessages();
     if(isspace(*dpos) || *dpos == 0){
       if(number != -1){
         if(negative) number*=-1;
         Add(number);
         number = -1;
         negative = false;
       }
     } else if(isdigit(*dpos)) {
       if (number == -1) {
         number = 0;
       } else {
         number *= 10;
       }
       number += *dpos - '0';
     } else if(*dpos == '-') {
       if(negative) {
         return dpos - ipos + 1;
       }
       negative = true;
     } else {
       return dpos - ipos + 1;
     }
   } while (*(dpos++) != 0);
   return 0;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------

