//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <alloc.h>
#include "program.h"
#include "appstrings.h"
#include "break.h"
#include "run.h"

//---------------------------------------------------------------------------
#pragma package(smart_init)
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
__fastcall TProgram::TProgram(void)
{
  vInstructions = 0;
  vInstrLabels = 0;
  vStacks = 0;
  vConditionList = 0;
}
//---------------------------------------------------------------------------
__fastcall TProgram::~TProgram(void)
{
  ClearInstructions();
  ClearInstrLabels();
  ClearStacks();
  ClearConditions();
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TProgram::ClearInstrLabels(void)
{
  while(vInstrLabels){
    vInstrLabelsPos = vInstrLabels;
    vInstrLabels = vInstrLabels->Next;
    free(vInstrLabelsPos->Name);
    delete vInstrLabelsPos;
  }
}
//---------------------------------------------------------------------------
void __fastcall TProgram::AddInstrLabel(char * vStr, PInstruction vInstruction)
{
  vInstrLabelsPos = new TInstrLabel;
  if((vInstrLabelsPos->Name = (char*)malloc(strlen(vStr)+1)) == 0)
    ShowErrorMsg(sCannotAllocateMemory);
  strcpy(vInstrLabelsPos->Name, vStr);
  vInstrLabelsPos->Destination = vInstruction;
  vInstrLabelsPos->Next = vInstrLabels;
  vInstrLabels = vInstrLabelsPos;
}
//---------------------------------------------------------------------------
PInstruction __fastcall TProgram::FindInstrLabel(char * vStr)
{
  vInstrLabelsPos = vInstrLabels;
  while(vInstrLabelsPos){
    if(stricmp(vInstrLabelsPos->Name, vStr) == 0) return vInstrLabelsPos->Destination;
    vInstrLabelsPos = vInstrLabelsPos->Next;
  }
  return 0;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TProgram::ClearStacks(void)
{
  while(vStacks){
    vStacksPos = vStacks;
    vStacks = vStacks->Next;
    free(vStacksPos->Name);
    delete vStacksPos;
  }
}
//---------------------------------------------------------------------------
bool __fastcall TProgram::AddStack(char * vStr)
{
  if(FindStack(vStr)) return false;
  vStacksPos = new TStack;
  if((vStacksPos->Name = (char*)malloc(strlen(vStr)+1)) == 0)
    ShowErrorMsg(sCannotAllocateMemory);
  strcpy(vStacksPos->Name, vStr);
  vStacksPos->StackItems = 0;
  vStacksPos->Next = vStacks;
  vStacks = vStacksPos;
  return true;
}
//---------------------------------------------------------------------------
PStack __fastcall TProgram::FindStack(char * vStr)
{
  if (!vStr) vStr = "";

  vStacksPos = vStacks;
  while(vStacksPos){
    if(stricmp(vStacksPos->Name, vStr) == 0) return vStacksPos;
    vStacksPos = vStacksPos->Next;
  }
  return 0;
}
//---------------------------------------------------------------------------
bool __fastcall TProgram::PushStackValue(PStack vStack, int * vValue)
{
  PStackItem vNewStackItem = new TStackItem;

  if (vNewStackItem == 0) {
    return false;
  }

  vNewStackItem->Value = *vValue;
  vNewStackItem->Next = vStack->StackItems;
  vStack->StackItems = vNewStackItem;

  return true;
}

//---------------------------------------------------------------------------
bool __fastcall TProgram::PopStackValue(PStack vStack)
{
  if (vStack->StackItems == 0) {
    ShowErrorMsg("Stack is empty! Cannot read value ...");
    return false;
  }

  PStackItem vStackItem = vStack->StackItems;
  vStack->StackItems = vStack->StackItems->Next;
  delete vStackItem;

  return true;
}

//---------------------------------------------------------------------------
bool __fastcall TProgram::PopStackValue(PStack vStack, int * vValue)
{
  if (vStack->StackItems == 0) {
    ShowErrorMsg("Stack is empty! Cannot read value ...");
    return false;
  }

  *vValue = vStack->StackItems->Value;

  PStackItem vStackItem = vStack->StackItems;
  vStack->StackItems = vStack->StackItems->Next;
  delete vStackItem;

  return true;
}

//---------------------------------------------------------------------------
int __fastcall TProgram::StacksCount (void)
{
  int count = 0;

  vStacksPos = vStacks;
  while(vStacksPos){
    vStacksPos = vStacksPos->Next;
    count++;
  }

  return count;
}

//---------------------------------------------------------------------------
PStack __fastcall TProgram::GetStackByNumber(int i)
{
  vStacksPos = vStacks;
  while(vStacksPos && i--){
    vStacksPos = vStacksPos->Next;
  }

  if (vStacksPos) {
    return vStacksPos;
  }

  return 0;
}

//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TProgram::ClearInstructions(void)
{
  while(vInstructions){
    vInstructionsPos = vInstructions;
    vInstructions = vInstructions->Next;
    delete vInstructionsPos;
  }
}
//---------------------------------------------------------------------------
PInstruction __fastcall TProgram::NewInstruction(void)
{
  vInstructionsPos = new TInstruction;
  vInstructionsPos->Type = IType_NONE;
  vInstructionsPos->Stack = 0;
  vInstructionsPos->Value = 0;
  vInstructionsPos->Condition = 0;
  vInstructionsPos->GotoLabelName = 0;
  vInstructionsPos->ElseLabelName = 0;
  vInstructionsPos->Goto = 0;
  vInstructionsPos->Else = 0;
  vInstructionsPos->Next = 0;
  vInstructionsPos->SourceChar = -1;
  vInstructionsPos->SourceLine = -1;

  AddInstruction(vInstructionsPos);
  return vInstructionsPos;
}
//---------------------------------------------------------------------------
void __fastcall TProgram::AddInstruction(PInstruction vNewInstruction)
{
  if (vInstructions == 0)
    vFirstInstruction = vNewInstruction;

  vNewInstruction->Next = vInstructions;
  vInstructions = vNewInstruction;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TProgram::ClearConditions(void)
{
  PCondition vConditionListPos;
  while(vConditionList){
    vConditionListPos = vConditionList;
    vConditionList = vConditionList->Next;
    delete vConditionListPos;
  }
}
//---------------------------------------------------------------------------
PCondition __fastcall TProgram::NewCondition(void)
{
  PCondition vNewCondition = new TCondition;
  vNewCondition->Type = CType_NONE;
  vNewCondition->Stack = 0;
  vNewCondition->SubCondition = 0;
  vNewCondition->Next = 0;

  vNewCondition->Next = vConditionList;
  vConditionList = vNewCondition;
  return vNewCondition;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
int __fastcall TProgram::LinkProgram(TStatusPanel * vStatusText)
{
  vInstructionsPos = vInstructions;

  while(vInstructionsPos->Next){
    vStatusText->Text = sSourceLine;
    vStatusText->Text += vInstructionsPos->Next->SourceChar;

    Application->ProcessMessages();

    if (vInstructionsPos->Next->GotoLabelName) {
      if((vInstructionsPos->Next->Goto = FindInstrLabel(vInstructionsPos->Next->GotoLabelName)) == 0) {
        ShowErrorMsg(sLabelIdentificatorNotFound);
        return vInstructionsPos->Next->SourceChar;
      }
    } else {
      if (vInstructionsPos->Next->Type == IType_EXIT) {
        vInstructionsPos->Next->Goto = 0;
      } else {
        vInstructionsPos->Next->Goto = vInstructionsPos;
        if (vInstructionsPos->Next->Goto->Type == IType_EXIT && vInstructionsPos->Next->Goto->SourceLine < 0) {
          vInstructionsPos->Next->Goto = 0;
        }
      }
    }

    if (vInstructionsPos->Next->ElseLabelName) {
      if((vInstructionsPos->Next->Else = FindInstrLabel(vInstructionsPos->Next->ElseLabelName)) == 0) {
        ShowErrorMsg(sLabelIdentificatorNotFound);
        return vInstructionsPos->Next->SourceChar;
      }
    } else vInstructionsPos->Next->Else = vInstructionsPos;

    vInstructionsPos = vInstructionsPos->Next;
  }

  vStatusText->Text = "";

  return -1;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
int __fastcall TProgram::RunProgram(TStatusPanel * vStatusText, TInputList * vInputList, void _fastcall WriteOutput (int), int vRunningState)
{
  vWorkingRegister = 0;
  RunningState = vRunningState;

  vInstructionsPos = vFirstInstruction;
  vInputList->Reset();
  
  return ContinueProgram(vStatusText, vInputList, WriteOutput);
}

int __fastcall TProgram::ContinueProgram(TStatusPanel * vStatusText, TInputList * vInputList, void _fastcall WriteOutput (int))
{
  static bool DisableBreakAtContinue = false;
  int vValue;

  while(vInstructionsPos && (RunningState & (RStateRunning | RStateNext)) && (DisableBreakAtContinue || !fBreak->GetBreakpoint (vInstructionsPos->SourceLine - 1))){
    vStatusText->Text = sSourceLine;
    vStatusText->Text += vInstructionsPos->SourceLine;
    Application->ProcessMessages();

    DisableBreakAtContinue = false;

    if (RunningState == RStateNext) {
      RunningState = RStateBreak;
    }

    switch (vInstructionsPos->Type) {
      case IType_SET:                                   // SET
      case IType_ADD:                                   // ADD
      case IType_SUB:                                   // SUB
      case IType_MUL:                                   // MUL
      case IType_DIV:                                   // DIV
        if (vInstructionsPos->Stack) {
          if(!PopStackValue(vInstructionsPos->Stack, & vValue))
            return vInstructionsPos->SourceChar;
        } else vValue = vInstructionsPos->Value;
        break;
      case IType_PUSH:                                  // PUSH
        if(!PushStackValue(vInstructionsPos->Stack, & vWorkingRegister))
          return vInstructionsPos->SourceChar;
        break;
      case IType_POP:                                   // POP
        if(!PopStackValue(vInstructionsPos->Stack))
          return vInstructionsPos->SourceChar;
        break;
    }

    switch (vInstructionsPos->Type) {
      case IType_SET:                                   // SET
        vWorkingRegister = vValue;
        break;
      case IType_ADD:                                   // ADD
        vWorkingRegister += vValue;
        break;
      case IType_SUB:                                   // SUB
        vWorkingRegister -= vValue;
        break;
      case IType_MUL:                                   // MUL
        vWorkingRegister *= vValue;
        break;
      case IType_DIV:                                   // DIV
        vWorkingRegister /= vValue;
        break;
      case IType_OUTPUT:                                // OUTPUT
        WriteOutput(vWorkingRegister);
        break;
    }

    switch (vInstructionsPos->Type) {
      case IType_NONE:                                  // NONE
      case IType_STACK:                                 // STACK
      case IType_EXIT:                                  // EXIT
      case IType_SET:                                   // ADD
      case IType_ADD:                                   // ADD
      case IType_SUB:                                   // SUB
      case IType_MUL:                                   // MUL
      case IType_DIV:                                   // DIV
      case IType_PUSH:                                  // PUSH
      case IType_POP:                                   // POP
      case IType_OUTPUT:                                // OUTPUT
      case IType_GOTO:                                  // GOTO
        vInstructionsPos = vInstructionsPos->Goto;
        break;
      case IType_INPUT:                                 // INPUT
        if(vInputList->Next(&vValue)) {
          vWorkingRegister = vValue;
          vInstructionsPos = vInstructionsPos->Goto;
        } else {
          vInstructionsPos = vInstructionsPos->Else;
        }
        break;
      case IType_IF:
        if (SolveCondition (vInstructionsPos->Condition))
          vInstructionsPos = vInstructionsPos->Goto;
        else
          vInstructionsPos = vInstructionsPos->Else;
        break;
    }
  }

  if (vInstructionsPos) {
    fRun->GotoLine = vInstructionsPos->SourceLine;

    if ((RunningState == RStateRunning) && fBreak->GetBreakpoint (vInstructionsPos->SourceLine - 1)) {
      DisableBreakAtContinue = true;
      fRun->AutoStopAtLine = 0;
      RunningState = RStateBreak;
    }
  } else {
    if (RunningState != RStateStop) {
      RunningState = RStateFinished;
    }
  }

  return -1;
}

int __fastcall TProgram::SolveCondition (PCondition vCondition)
{
  if (!vCondition)
  {
    ShowErrorMsg (sInternalIllegalCondition);
    RunningState = RStateError;
    return false;
  }

  switch (vCondition->Type)
  {
  case CType_NONE:
    return false;

  case CType_ZERO:
    return (vWorkingRegister == 0);

  case CType_NEG:
    return (vWorkingRegister < 0);

  case CType_EMPTY:
    return (vCondition->Stack->StackItems == 0);

  case CType_NOT:
    return ! (SolveCondition (vCondition->SubCondition));

  default:
    ShowErrorMsg (sInternalIllegalCondition);
    return false;
  }
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------

