//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <alloc.h>
#include <stdlib.h>

#include "appstrings.h"
#include "editor.h"
#include "input.h"
#include "run.h"
#include "break.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TfRun *fRun;
//---------------------------------------------------------------------------
__fastcall TfRun::TfRun(TComponent* Owner): TForm(Owner){}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfRun::FormCreate(TObject *Sender)
{
  oProgram = new TProgram;
}
//---------------------------------------------------------------------------
void __fastcall TfRun::FormDestroy(TObject *Sender)
{
  delete oProgram;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
void __fastcall TfRun::FormShow(TObject *Sender)
{
  Caption = fMain->Caption + " - [run]";
  fRun->oText->Lines->Clear();

  oTimer->Enabled = true;
}
//---------------------------------------------------------------------------
void __fastcall TfRun::oTimerTimer(TObject *Sender)
{
  oTimer->Enabled = false;
  Run();
}
//---------------------------------------------------------------------------
void __fastcall TfRun::mCloseClick(TObject *Sender)
{
  if (oProgram->RunningState & (RStateError | RStateStop | RStateFinished)) {
    Close();
  } else {
    ShowErrorMsg(sCannotCloseWhileRunning);
  }
}

void __fastcall TfRun::FormClose(TObject *Sender, TCloseAction &Action)
{
  if (oProgram->RunningState & (RStateError | RStateStop | RStateFinished)) {
    Action = caHide;
  } else {
    ShowErrorMsg(sCannotCloseWhileRunning);
    Action = caNone;
  }
}

//---------------------------------------------------------------------------
void __fastcall TfRun::mStopClick(TObject *Sender)
{
  oProgram->RunningState = RStateStop;
}

//---------------------------------------------------------------------------
void __fastcall TfRun::mBreakClick(TObject *Sender)
{
  if (oProgram->RunningState != RStateRunning) return;

  oProgram->RunningState = RStateBreak;
}

//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
int  __fastcall TfRun::GetWorkingRegisterValue (void)
{
  return oProgram->vWorkingRegister;
}

//---------------------------------------------------------------------------
void __fastcall WriteOutput(int vValue)
{
  char vStr[20];
  itoa (vValue, vStr, 10);
  fRun->oText->Text = fRun->oText->Text + vStr;
  fRun->oText->Text = fRun->oText->Text + " ";
}

//---------------------------------------------------------------------------
void __fastcall TfRun::Run(void)
{
  // parse program
  oStatusBar->Panels->Items[1]->Text = sParsingProgram;
  if (0 != (GotoPos = ParseProgram() + 1)) {
    oProgram->RunningState = RStateError;
    ModalResult = RResultError;
    return;
  }

  // link program
  oStatusBar->Panels->Items[1]->Text = sLinkingProgram;
  if (0 != (GotoPos = oProgram->LinkProgram(oStatusBar->Panels->Items[0]) + 1)) {
    oProgram->RunningState = RStateError;
    ModalResult = RResultError;
    return;
  }

  // read input
  oStatusBar->Panels->Items[1]->Text = sWaitingForInput;
  if(fInput->ShowModal() == mrCancel) {
    oProgram->RunningState = RStateError;
    ModalResult = RResultCancel;
    return;
  }

  // menu items
  mClose->Enabled = false;
  mBreak->Enabled = true;
  mStop->Enabled = true;

  // run program
  fBreak->ResetBreak ();
  oStatusBar->Panels->Items[1]->Text = sRunningProgram;
  if (0 != (GotoPos = oProgram->RunProgram(oStatusBar->Panels->Items[0], fInput->oInputList, WriteOutput, RunAs) + 1)) {
    oProgram->RunningState = RStateError;
    ModalResult = RResultError;
    return;
  }

  // if debuging
  while (oProgram->RunningState == RStateBreak)
  {
    switch (fBreak->ShowModal ()) {
    case BResultContinue:
      oProgram->RunningState = RStateRunning;
      break;
    case BResultNext:
      oProgram->RunningState = RStateNext;
      break;
    case BResultStop:
      oProgram->RunningState = RStateStop;
      break;
    }

    if (0 != (GotoPos = oProgram->ContinueProgram(oStatusBar->Panels->Items[0], fInput->oInputList, WriteOutput) + 1)) {
      oProgram->RunningState = RStateError;
      ModalResult = RResultError;
      return;
    }
  }

  // menu items  
  mClose->Enabled = true;
  mBreak->Enabled = false;
  mStop->Enabled = false;

  // caption 
  switch (oProgram->RunningState) {
  case RStateFinished:
    Caption = fMain->Caption + " - [finished]";
    break;
  case RStateStop:
    Caption = fMain->Caption + " - [stop]";
    break;
  }

  oStatusBar->Panels->Items[0]->Text = "";
  oStatusBar->Panels->Items[1]->Text = "";
}

//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------
#define WType_EndOfStr         0
#define WType_EndOfLine        1
#define WType_EndOfWord        2
#define WType_EndOfLabel       3
#define WType_ErrorIllegalChar 101

int GetNextWord (char ** vStr, char ** vWord)
{
  *vWord = 0;
  char * vLabelName = 0;

  while (**vStr != 0) {
    if (**vStr == '\r')                           // if new-line found
     {
      **vStr = 0; (*vStr) += 2;
      return WType_EndOfLine;
     }
    else if (**vStr == '/')                        // if comment starts here
     {
      **vStr = 0; (*vStr)++;

      if(**vStr != '/') {
        (*vStr)--;
        ShowErrorMsg(sUnrecognizedCharacter);
        return WType_ErrorIllegalChar;
      }

      while (**vStr != 0 && **vStr != '\n') (*vStr)++;
      if(**vStr == 0)
        return WType_EndOfStr;
      if(**vStr == '\n') {
         (*vStr)++;
        return WType_EndOfLine;
      }
     }
    else if (**vStr == ':')                        // if label identificator is found
      vLabelName = (*vStr) + 1;
    else if (isspace(**vStr))                      // if 'space' is found (end of 'word' may be here)
     {
      if (vLabelName) {
        *vWord = vLabelName;
        **vStr = 0; (*vStr)++;
        return WType_EndOfLabel;
      }
      if (*vWord) {
        **vStr = 0; (*vStr)++;
        return WType_EndOfWord;
      }
     }
    else if (isalnum(**vStr) || **vStr == '_' || (!*vWord && !vLabelName && **vStr == '-'))      // if legal character is found (alphanum, underscore or minus at the beginning (as a negative number))
     {
       if(!*vWord) *vWord = *vStr;
     }
    else                                           // if ilegal character is found
     {
      ShowErrorMsg(sUnrecognizedCharacter);
      return WType_ErrorIllegalChar;
     }
    (*vStr)++;
  }
  return WType_EndOfStr;
}

//---------------------------------------------------------------------------
int GetIntFromWord (char * vWord, int * vValue)
{
  int negative = 1;

  *vValue = 0;

  if (*vWord == '-') {
    if (tolower (vWord[1]) == 'm') {  // min/max integer values
      if (tolower (vWord[2]) == 'i' && tolower (vWord[3]) == 'n' && !vWord[4]) {
        *vValue = 0xC0000000;
        return 0;
      }
      if (tolower (vWord[2]) == 'a' && tolower (vWord[3]) == 'x' && !vWord[4]) {
        *vValue = 0x3FFFFFFF;
        return 0;
      }
    }

    negative = -1;
    if (!*++vWord) {
      ShowErrorMsg(sNumberExpected);
      return WType_ErrorIllegalChar;
    }
  }

  while (isdigit (*vWord)) {
   *vValue = (*vValue) * 10 + (*vWord++) - '0';
  }

  *vValue *= negative;

  if (*vWord) {
    ShowErrorMsg(sNumberExpected);
    return WType_ErrorIllegalChar;
  }
  return 0;
}

//---------------------------------------------------------------------------
PCondition TfRun::ReadCondition(char ** vStr, char ** vWord)
{
  int vWordType;
  PCondition vCondition = oProgram->NewCondition();

  if((vWordType = GetNextWord(vStr, vWord)) == WType_ErrorIllegalChar) return 0;
  if (!(*vWord)) { ShowErrorMsg(sConditionExpected); return 0; }

  if (vWordType != WType_EndOfWord) {
    ShowErrorMsg(sUnexpectedEndOfLine);
    return 0;
  }

  if (stricmp(*vWord, "ZERO") == 0)        // ZERO
   {
    vCondition->Type = CType_ZERO;
   }
  else if (stricmp(*vWord, "NEG") == 0)    // NEG
   {
    vCondition->Type = CType_NEG;
   }
  else if (stricmp(*vWord, "EMPTY") == 0)  // EMPTY
   {
    vCondition->Type = CType_EMPTY;

    if((vWordType = GetNextWord(vStr, vWord)) == WType_ErrorIllegalChar) return 0;

    if (!(*vWord)) { ShowErrorMsg(sGOTOOrStackIdentificatorExpected); return 0; }

    if (stricmp(*vWord, "GOTO") != 0) {         // if EMPTY condition have stack identificator
      if((vCondition->Stack = oProgram->FindStack(*vWord)) == 0) {
        ShowErrorMsg(sUnknownStackIdentificator);
        return 0;
      }
    } else {
        vCondition->Stack = oProgram->FindStack("");    
    }
   }
  else if (stricmp(*vWord, "NOT") == 0)    // NOT
   {
    vCondition->Type = CType_NOT;
    if((vCondition->SubCondition = ReadCondition(vStr, vWord)) == 0) {
      return 0;
    }
   }
  else                                     // unexpected word have been found
   {
    ShowErrorMsg(sUnrecognizedCondition);
    return 0;
   }

  if (vCondition->Type != CType_NONE) {
    return vCondition;
  }

  ShowErrorMsg(sUnrecognizedCondition);
  return 0;
}

//---------------------------------------------------------------------------
int __fastcall TfRun::ParseProgram(void)
{
  oProgram->ClearInstructions();
  oProgram->ClearStacks();
  oProgram->ClearInstrLabels();
  oProgram->ClearConditions();

  PInstruction vInstruction = oProgram->NewInstruction();

  int vLine = 1;
  oStatusBar->Panels->Items[0]->Text = "Line: ";        // update status bar
  oStatusBar->Panels->Items[0]->Text += vLine;
  Application->ProcessMessages();

  AnsiString vText = fMain->oText->Text;
  char * vTextStr = vText.c_str();
  char * vStr = vTextStr;
  char * vWord = 0;
  int vWordType;

  bool vStacksNotAllowed = false;
  bool vStackNameExpected = false;

  oProgram->AddStack("");                     // primary stack

  do {
    vWordType = GetNextWord(& vStr, & vWord);

    if (vWordType == WType_EndOfLabel) {
      oProgram->AddInstrLabel(vWord, vInstruction);
      vStacksNotAllowed = true;
      vWordType = GetNextWord(& vStr, & vWord);
    }

    switch (vWordType) {
     case WType_ErrorIllegalChar:                       // unexpected character have been found
        return vStr - vTextStr;
     case WType_EndOfStr:                               // word might have been found
     case WType_EndOfLine:                              // word might have been found
       if (!vWord) break;
     case WType_EndOfWord:                              // word have been found
       if (stricmp(vWord, "STACK") == 0)      // STACK
        {
         if(vStacksNotAllowed) {
           ShowErrorMsg(sSTACKMustBeFirst);
           return vWord - vTextStr;
         }

         vInstruction->Type = IType_STACK;
         vInstruction->SourceChar = vWord - vTextStr;

         while (vWordType == WType_EndOfWord) {
           if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
             return vStr - vTextStr;
           }
           if(vWord && *vWord) {
             if (isdigit(*vWord) || *vWord == '-') {
               ShowErrorMsg(sIllegalStackIdentificator);
               return vWord - vTextStr;
             }
             if(!oProgram->AddStack(vWord)) {
               ShowErrorMsg(sEachStackIdentificatorMustBeUnique);
               return vWord - vTextStr;
             }
           }
         }
        }
       else if (stricmp(vWord, "SET") == 0)   // SET
        {
         vInstruction->Type = IType_SET;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "ADD") == 0)   // ADD
        {
         vInstruction->Type = IType_ADD;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "SUB") == 0)   // SUB
        {
         vInstruction->Type = IType_SUB;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "MUL") == 0)   // MUL
        {
         vInstruction->Type = IType_MUL;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "DIV") == 0)   // DIV
        {
         vInstruction->Type = IType_DIV;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "PUSH") == 0)  // PUSH
        {
         vInstruction->Type = IType_PUSH;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "POP") == 0)   // POP
        {
         vInstruction->Type = IType_POP;
         vInstruction->SourceChar = vWord - vTextStr;
         vStackNameExpected = true;
        }
       else if (stricmp(vWord, "INPUT") == 0) // INPUT
        {
         vInstruction->Type = IType_INPUT;
         vInstruction->SourceChar = vWord - vTextStr;

         if (vWordType != WType_EndOfWord) {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vInstruction->SourceChar;
         }

         if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
           return vStr - vTextStr;
         }

         if(!vWord) {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vInstruction->SourceChar;
         }

         if(*vWord == '-') {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vWord - vTextStr;
         }

         if((vInstruction->ElseLabelName = (char*)malloc(strlen(vWord)+1)) == 0)
          ShowErrorMsg(sCannotAllocateMemory);
         strcpy(vInstruction->ElseLabelName, vWord);
        }
       else if (stricmp(vWord, "OUTPUT") == 0)// OUTPUT
        {
         vInstruction->Type = IType_OUTPUT;
         vInstruction->SourceChar = vWord - vTextStr;
        }
       else if (stricmp(vWord, "EXIT") == 0)  // EXIT
        {
         vInstruction->Type = IType_EXIT;
         vInstruction->SourceChar = vWord - vTextStr;
        }
       else if (stricmp(vWord, "GOTO") == 0)  // GOTO
        {
         vInstruction->Type = IType_GOTO;
         vInstruction->SourceChar = vWord - vTextStr;

         if (vWordType != WType_EndOfWord) {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vInstruction->SourceChar;
         }

         if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
           return vStr - vTextStr;
         }

         if(!vWord) {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vInstruction->SourceChar;
         }

         if(*vWord == '-') {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vWord - vTextStr;
         }

         if((vInstruction->GotoLabelName = (char*)malloc(strlen(vWord)+1)) == 0)
          ShowErrorMsg(sCannotAllocateMemory);
         strcpy(vInstruction->GotoLabelName, vWord);
        }
       else if (stricmp(vWord, "IF") == 0)    // IF
        {
         vInstruction->Type = IType_IF;
         vInstruction->SourceChar = vWord - vTextStr;
         if (vWordType != WType_EndOfWord) {
           ShowErrorMsg(sConditionExpected);
           return vStr - vTextStr;
         }

         if((vInstruction->Condition = ReadCondition(& vStr, &vWord)) == 0) {
           return vStr - vTextStr;
         }

         if ((!vWord) || (stricmp(vWord, "GOTO") != 0)) {     // if ReadCondition function didn`t read GOTO ....
           if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
             return vStr - vTextStr;
           }
         }

         if ((!vWord) || (stricmp(vWord, "GOTO") != 0)) {     // if still no GOTO found...
           ShowErrorMsg(sGOTOExpected);
           return vWord - vTextStr;
         }

         if (vWordType != WType_EndOfWord) {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vWord - vTextStr;
         }

         if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
           return vStr - vTextStr;
         }

         if(!vWord) {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vStr - vTextStr;
         }

         if(*vWord == '-') {
           ShowErrorMsg(sLabelIdentificatorExpected);
           return vWord - vTextStr;
         }

         if((vInstruction->GotoLabelName = (char*)malloc(strlen(vWord)+1)) == 0)
          ShowErrorMsg(sCannotAllocateMemory);
         strcpy(vInstruction->GotoLabelName, vWord);

         if (vWordType == WType_EndOfWord)
          {
           if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
             return vStr - vTextStr;
           }
           if (vWord) {
             if (stricmp(vWord, "ELSE") != 0) {
               ShowErrorMsg(sELSEExpected);
               return vWord - vTextStr;
             }

             if (vWordType != WType_EndOfWord) {
               ShowErrorMsg(sLabelIdentificatorExpected);
               return vStr - vTextStr;
             }

             if((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
               return vStr - vTextStr;
             }

             if(!vWord) {
               ShowErrorMsg(sLabelIdentificatorExpected);
               return vStr - vTextStr;
             }

             if(*vWord == '-') {
               ShowErrorMsg(sLabelIdentificatorExpected);
               return vWord - vTextStr;
             }

             if((vInstruction->ElseLabelName = (char*)malloc(strlen(vWord)+1)) == 0)
              ShowErrorMsg(sCannotAllocateMemory);
             strcpy(vInstruction->ElseLabelName, vWord);
           }
          }
        }
       else                                             // unexpected word have been found
        {
         ShowErrorMsg(sUnexpectedExpression);
         return vWord - vTextStr;
        }


       if (vStackNameExpected) {                        // common part for SET, ADD, SUB, MUL, DIV, PUSH, POP
        if (vWordType == WType_EndOfWord) {
          if ((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
            return vStr - vTextStr;
          }
          if (vWord) {
            // a number instead of stack name is found
            if (*vWord == '-' || isdigit(*vWord)) {
              switch (vInstruction->Type)
              {
              case IType_SET:
              case IType_ADD:
              case IType_SUB:
              case IType_MUL:
              case IType_DIV:
                if (GetIntFromWord (vWord, &(vInstruction->Value)) == WType_ErrorIllegalChar) {
                  return vWord - vTextStr;
                }
                break;
              default:
                ShowErrorMsg (sIllegalStackIdentificator);
                return vWord - vTextStr;
              }
            } else if((vInstruction->Stack = oProgram->FindStack(vWord)) == 0) {
                ShowErrorMsg(sUnknownStackIdentificator);
                return vWord - vTextStr;
            }
          } else vInstruction->Stack = oProgram->FindStack("");
        } else vInstruction->Stack = oProgram->FindStack("");
        vStackNameExpected = false;
       }
       break;
    }

    if (vWordType == WType_EndOfWord) {                  // if not end of line
      if ((vWordType = GetNextWord(& vStr, & vWord)) == WType_ErrorIllegalChar) {
        return vStr - vTextStr;
      }
      if (vWord) {
        ShowErrorMsg(sEndOfLineExpected);
        return vWord - vTextStr;
      }
    }

    vInstruction->SourceLine = vLine;

    if (vInstruction->Type != IType_NONE){              // start new instruction, if last was not NONE
      vInstruction = oProgram->NewInstruction();
      vStacksNotAllowed = true;
    }

    oStatusBar->Panels->Items[0]->Text = sSourceLine;
    oStatusBar->Panels->Items[0]->Text += (++vLine);
    Application->ProcessMessages();

  } while (vWordType != WType_EndOfStr);

  vInstruction->Type = IType_EXIT;
  vInstruction->SourceChar = -1;
  vInstruction->SourceLine = -1;

  oStatusBar->Panels->Items[0]->Text = "";

  return -1;
}
//---------------------------------------------------------------------------
/**/         /*###############################################*/         /**/
//---------------------------------------------------------------------------




//---------------------------------------------------------------------------

//---------------------------------------------------------------------------


//---------------------------------------------------------------------------

